using System;
using System.Xml.Serialization;
using System.Collections.Generic;
using VdcUtils;
using System.Linq;

namespace VdcCommon.BusinessEntities
{
   
    public partial class VdsVersion
    {
        private Version mFullVersion;

        [XmlIgnoreAttribute]
        public Version FullVersion
        {
            get
            {
                if (mFullVersion == null)
                {
                    //defencive code for prevent incorrect versioning
                    try
                    {
                        if (SoftwareVersion != null && SoftwareRevision != null)
                        {
                            string stringVersion;
                            string[] revision = SoftwareRevision.Split('.');

                            if (revision.Length > 1)
                            {
                                stringVersion = string.Format("{0}.{1}", SoftwareVersion, SoftwareRevision);
                            }
                            else
                            {
                                stringVersion = string.Format("{0}.0.{1}", SoftwareVersion, SoftwareRevision);
                            }

                            mFullVersion = new Version(stringVersion);
                        }
                    }
                    catch
                    {
                        QLogger.Instance.WarnFormat("Couldn't parse vds version: {0} , {1}", SoftwareVersion, SoftwareRevision);
                    }
                }

                return mFullVersion;
            }
        }
        [XmlIgnoreAttribute]
        public Version PartialVersion
        {
            get
            {
                return SoftwareVersion == null ? null : new Version(SoftwareVersion);
            }
        }

		public override bool Equals(object obj)
		{
			if (base.Equals(obj))
			{
				return true;
			}

			VdsVersion other = obj as VdsVersion;
			if (other == null)
			{
				return false;
			}
			return (FullVersion == null && other.FullVersion == null) ||
				(FullVersion != null && FullVersion.Equals(other.FullVersion));
		}

		public override int GetHashCode()
		{
			return FullVersion != null ? FullVersion.GetHashCode() : -1;
		}
    }
  
    public enum VDSNiceType
    {
        RHEL = 0,
        RHEVH = 2
    }

   
    public partial class VDS : IVdcQueryable
	{
        #region IVdcQueryable Members

        [XmlIgnoreAttribute]
        public override object QueryableId
        {
            get { return vds_id; }
        }

    	private static readonly List<string> _vdsProperties =
    		new List<string>
    		{
                "NonOperationalReason",                
    			"vds_name",
    			"status",
    			"usage_cpu_percent",
    			"usage_mem_percent",
    			"usage_network_percent",
    			"mem_commited",
    			"vm_count",
    			"vm_active",
    			"host_name",
    			"vds_group_name",
    			"vds_type",
    			"CpuName",
    			"vds_group_id",
    			"net_config_dirty",
    			"spm_status",
    			"pm_enabled",
    			"pm_user",
    			"pm_password",
    			"pm_type",
    			"pm_port",
    			"pm_options",
    			"vms_cores_count",
    			"ksm_state",
    			"mem_shared",
    			"Version",
    			"vds_group_compatibility_version",
    			"UniqueId",
    			"IScsiInitiatorName",
    			"TransparentHugePagesState",
				"swap_free",
				"swap_total",
				"mem_shared_percent",
				"ManagmentIp",
				"supported_cluster_levels",
				"PmOptionsMap",
				"ContainingHooks",
				"host_os",
				"kernel_version",
				"spice_version",
				"kvm_version",
				"storage_pool_id",
				"physical_mem_mb"
    		};

    	[XmlIgnoreAttribute]
		public override List<string> ChangeablePropertiesList
		{
            get { return _vdsProperties; }
		}


        #endregion
	}
}
